<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo e($page->meta_title ?? $tenant->brand_name); ?></title>
    <meta name="description" content="<?php echo e($page->meta_description); ?>">
    <meta name="keywords" content="<?php echo e($page->keywords); ?>">
    <link rel="canonical" href="<?php echo e(url()->current()); ?>">

    <?php if($page->schema_json): ?>
    <script type="application/ld+json">
        <?php echo json_encode($page->schema_json, JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT); ?>

    </script>
    <?php endif; ?>

    <style>
        :root {
            --primary: <?php echo e($tenant->primary_color ?? '#0d6efd'); ?>;
            --secondary: <?php echo e($tenant->secondary_color ?? '#6c757d'); ?>;
        }
    </style>
</head>
<body>
    <header style="background: var(--primary); color: #fff; padding: 20px;">
        <?php if($tenant->logo): ?>
            <img src="<?php echo e(asset($tenant->logo)); ?>" alt="<?php echo e($tenant->brand_name); ?>" height="50">
        <?php else: ?>
            <h1><?php echo e($tenant->brand_name); ?></h1>
        <?php endif; ?>
    </header>

    <main style="padding: 40px;">
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <footer style="background: var(--secondary); color: #fff; padding: 20px;">
        <p>&copy; <?php echo e(date('Y')); ?> <?php echo e($tenant->brand_name); ?>. All rights reserved.</p>
    </footer>
</body>
</html>
<?php /**PATH C:\emd-multitenant\resources\views/layouts/app.blade.php ENDPATH**/ ?>