<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>{{ $page->meta_title ?? $tenant->brand_name }}</title>
    <meta name="description" content="{{ $page->meta_description }}">
    <meta name="keywords" content="{{ $page->keywords }}">
    <link rel="canonical" href="{{ url()->current() }}">

    @if($page->schema_json)
    <script type="application/ld+json">
        {!! json_encode($page->schema_json, JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT) !!}
    </script>
    @endif

    <style>
        :root {
            --primary: {{ $tenant->primary_color ?? '#0d6efd' }};
            --secondary: {{ $tenant->secondary_color ?? '#6c757d' }};
        }
    </style>
</head>
<body>
    <header style="background: var(--primary); color: #fff; padding: 20px;">
        @if($tenant->logo)
            <img src="{{ asset($tenant->logo) }}" alt="{{ $tenant->brand_name }}" height="50">
        @else
            <h1>{{ $tenant->brand_name }}</h1>
        @endif
    </header>

    <main style="padding: 40px;">
        @yield('content')
    </main>

    <footer style="background: var(--secondary); color: #fff; padding: 20px;">
        <p>&copy; {{ date('Y') }} {{ $tenant->brand_name }}. All rights reserved.</p>
    </footer>
</body>
</html>
