<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PageContent extends Model
{
    use HasFactory;

    protected $fillable = [
        'tenant_id',
        'slug',
        'page_name',
        'meta_title',
        'meta_description',
        'callback_image',
        'keywords',
        'content_html',
        'indexable',
    ];

    // Relationship: Page belongs to Tenant
    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }
}
