<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\Tenant;

class TenantResolver
{
    public function handle(Request $request, Closure $next)
    {
        // Remove port if running locally (e.g., localhost:8000)
        $host = explode(':', $request->getHost())[0];

        \Log::info("TenantResolver running for host: $host");

        $tenant = Tenant::where('domain', $host)->first();

        if (!$tenant) {
            \Log::error("Tenant not found for host: $host");
            abort(404, "Tenant not found");
        }

        \Log::info("Tenant loaded: ".$tenant->brand_name);

        // Make tenant accessible everywhere
        $request->attributes->set('tenant', $tenant);
        app()->instance('tenant', $tenant);
        view()->share('tenant', $tenant);

        return $next($request);
    }
}
