<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\PageContent;
use App\Models\Tenant;


class PageController extends Controller
{
        public function home(Request $request)
        {
            $domain = $_SERVER['HTTP_HOST'];

            $tenant = Tenant::where('domain',$domain)->first();
            if(!$tenant){
                \Log::error("Tenant is null in controller");
                abort(500, "Tenant not set in request");
            }

          
            $page = PageContent::where('tenant_id', 1)
                            ->where('slug','home')
                            ->firstOrFail();

        

            return view('pages.default', compact('page','tenant'));
        }

    public function show(Request $request, $slug)
    {
        $tenant = $request->attributes->get('tenant');

        if (!$tenant) {
            abort(500, "Tenant not set in request.");
        }

        $page = PageContent::where('tenant_id', $tenant->id)
                           ->where('slug', $slug)
                           ->where('indexable', true)
                           ->firstOrFail();

        return view('pages.default', compact('page', 'tenant'));
    }
}
